/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.agent.profiler;

import java.util.SortedSet;
import java.util.concurrent.TimeUnit;
import org.snapscript.agent.profiler.ProfileResult;

public class ResourceProfiler {
    private volatile String resource;
    private volatile int[] counts;
    private volatile int[] visits;
    private volatile long[] start = new long[500];
    private volatile long[] times;
    private volatile int max;

    public ResourceProfiler(String resource) {
        this.counts = new int[500];
        this.times = new long[500];
        this.visits = new int[500];
        this.resource = resource;
        this.max = 0;
    }

    public void collect(SortedSet<ProfileResult> results, int size) {
        long localMax = this.max;
        long[] localTimes = this.times;
        int[] localVisits = this.visits;
        for (int i = 0; (long)i < localMax && i < size; ++i) {
            if (localTimes[i] <= 0L) continue;
            long duration = TimeUnit.NANOSECONDS.toMillis(localTimes[i]);
            int visits = localVisits[i];
            results.add(new ProfileResult(this.resource, duration, visits, i));
        }
    }

    public void enter(int line) {
        if (line >= 0) {
            if (this.times.length <= line) {
                this.counts = this.copyOf(this.counts, line + 50);
                this.times = this.copyOf(this.times, line + 50);
                this.start = this.copyOf(this.start, line + 50);
                this.visits = this.copyOf(this.visits, line + 50);
            }
            int n = line;
            int n2 = this.counts[n];
            this.counts[n] = n2 + 1;
            int currentCount = n2;
            if (currentCount == 0) {
                this.start[line] = System.nanoTime();
            }
            int n3 = line;
            this.visits[n3] = this.visits[n3] + 1;
        }
    }

    public void exit(int line) {
        if (line >= 0) {
            int n = line;
            this.counts[n] = this.counts[n] - 1;
            int currentCount = this.counts[n];
            if (currentCount == 0) {
                int n2 = line;
                this.times[n2] = this.times[n2] + (System.nanoTime() - this.start[line]);
                this.start[line] = 0L;
            }
            if (line > this.max) {
                this.max = line;
            }
        }
    }

    private int[] copyOf(int[] array, int newSize) {
        int[] copy = new int[newSize];
        System.arraycopy(array, 0, copy, 0, Math.min(newSize, array.length));
        return copy;
    }

    private long[] copyOf(long[] array, int newSize) {
        long[] copy = new long[newSize];
        System.arraycopy(array, 0, copy, 0, Math.min(newSize, array.length));
        return copy;
    }
}

