/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.bridge.android;

import org.snapscript.bridge.generate.ClassGenerator;
import org.snapscript.common.Cache;
import org.snapscript.common.CopyOnWriteCache;
import org.snapscript.core.Scope;
import org.snapscript.dx.stock.ProxyBuilder;

public class ProxyBuilderGenerator
implements ClassGenerator {
    private final Cache<Class, Class> cache = new CopyOnWriteCache<Class, Class>();
    private final Class[] interfaces;

    public ProxyBuilderGenerator(Class ... interfaces) {
        this.interfaces = interfaces;
    }

    @Override
    public Class generate(Scope scope, Class type) {
        Class proxy = this.cache.fetch(type);
        if (proxy == null) {
            proxy = this.create(scope, type);
            this.cache.cache(type, proxy);
        }
        return proxy;
    }

    private Class create(Scope scope, Class type) {
        try {
            return ProxyBuilder.forClass(type).implementing(this.interfaces).buildProxyClass();
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not create proxy for " + type, e);
        }
    }
}

