/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.bridge.generate;

import org.snapscript.bridge.generate.BridgeInstance;
import org.snapscript.bridge.generate.BridgeInstanceConverter;
import org.snapscript.bridge.generate.ClassGenerator;
import org.snapscript.bridge.generate.ObjectGenerator;
import org.snapscript.core.Module;
import org.snapscript.core.Scope;
import org.snapscript.core.Type;
import org.snapscript.core.bind.FunctionResolver;
import org.snapscript.core.define.Instance;

public class BridgeInstanceBuilder {
    private final BridgeInstanceConverter converter;
    private final ObjectGenerator generator;
    private final Type type;

    public BridgeInstanceBuilder(ClassGenerator generator, FunctionResolver resolver, Type type) {
        this.generator = new ObjectGenerator(generator, resolver);
        this.converter = new BridgeInstanceConverter(type);
        this.type = type;
    }

    public Instance createInstance(Scope scope, Type real, Object ... arguments) throws Exception {
        Instance instance = this.createBridge(scope, real, arguments);
        this.converter.convert(instance);
        return instance;
    }

    private Instance createBridge(Scope scope, Type real, Object ... arguments) throws Exception {
        Class base = this.type.getType();
        Module module = scope.getModule();
        Object object = this.generator.generate(scope, base, arguments);
        return new BridgeInstance(module, object, this.type, real);
    }
}

