/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.bridge.generate;

import java.util.List;
import org.snapscript.core.State;
import org.snapscript.core.Type;
import org.snapscript.core.Value;
import org.snapscript.core.ValueType;
import org.snapscript.core.define.Instance;
import org.snapscript.core.property.Property;
import org.snapscript.core.property.PropertyValue;

public class BridgeInstanceConverter {
    private final Type type;

    public BridgeInstanceConverter(Type type) {
        this.type = type;
    }

    public void convert(Instance instance) {
        Value self = ValueType.getReference(instance);
        List<Type> types = this.type.getTypes();
        State state = instance.getState();
        Object bridge = instance.getBridge();
        this.update(state, bridge, this.type);
        for (Type type : types) {
            this.update(state, bridge, type);
        }
        state.add("this", self);
    }

    private void update(State state, Object object, Type type) {
        List<Property> properties = type.getProperties();
        for (Property prop : properties) {
            Value current;
            String name = prop.getName();
            if (name.equals("this") || (current = state.get(name)) != null) continue;
            PropertyValue value = new PropertyValue(prop, object, name);
            state.add(name, value);
        }
    }
}

