/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.bridge.generate;

import org.snapscript.bridge.generate.ClassGenerator;
import org.snapscript.bridge.generate.ConstructorArguments;
import org.snapscript.bridge.generate.ConstructorResolver;
import org.snapscript.core.Context;
import org.snapscript.core.Module;
import org.snapscript.core.Scope;
import org.snapscript.core.Type;
import org.snapscript.core.TypeLoader;
import org.snapscript.core.bind.FunctionResolver;

public class ObjectGenerator {
    private final ConstructorResolver resolver;
    private final ClassGenerator generator;

    public ObjectGenerator(ClassGenerator generator, FunctionResolver resolver) {
        this.resolver = new ConstructorResolver(resolver);
        this.generator = generator;
    }

    public Object generate(Scope scope, Class type, Object ... arguments) throws Exception {
        Class proxy = this.generator.generate(scope, type);
        Module module = scope.getModule();
        Context context = module.getContext();
        TypeLoader loader = context.getLoader();
        Type match = loader.loadType(type);
        ConstructorArguments data = this.resolver.findConstructor(scope, match, arguments);
        Object[] converted = data.getArguments();
        Class[] types = data.getTypes();
        return proxy.getDeclaredConstructor(types).newInstance(converted);
    }
}

