/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.bridge.standard;

import org.snapscript.bridge.generate.ClassGenerator;
import org.snapscript.cglib.proxy.Enhancer;
import org.snapscript.cglib.proxy.MethodInterceptor;
import org.snapscript.common.Cache;
import org.snapscript.common.CopyOnWriteCache;
import org.snapscript.core.Scope;
import org.snapscript.core.convert.InterfaceCollector;

public class EnhancerGenerator
implements ClassGenerator {
    private final InterfaceCollector collector;
    private final Cache<Class, Class> cache;

    public EnhancerGenerator(Class ... interfaces) {
        this.collector = new InterfaceCollector(interfaces);
        this.cache = new CopyOnWriteCache<Class, Class>();
    }

    @Override
    public Class generate(Scope scope, Class type) {
        Class proxy = this.cache.fetch(type);
        if (proxy == null) {
            proxy = this.create(scope, type);
            this.cache.cache(type, proxy);
        }
        return proxy;
    }

    private Class create(Scope scope, Class type) {
        Class[] types = this.collector.collect(scope);
        try {
            Class[] handlers = new Class[]{MethodInterceptor.class};
            Enhancer enhancer = new Enhancer();
            enhancer.setSuperclass(type);
            enhancer.setInterfaces(types);
            enhancer.setCallbackTypes(handlers);
            return enhancer.createClass();
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not create proxy for " + type, e);
        }
    }
}

