/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.common;

import java.util.Iterator;
import org.snapscript.common.Stack;

public class ArrayStack<T>
implements Stack<T> {
    private Object[] stack;
    private int count;

    public ArrayStack() {
        this(1024);
    }

    public ArrayStack(int capacity) {
        this.stack = new Object[capacity];
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new ArrayIterator(this.count - 1);
    }

    @Override
    public T get(int index) {
        if (index < this.count) {
            return (T)this.stack[index];
        }
        return null;
    }

    @Override
    public boolean contains(T value) {
        for (int i = 0; i < this.count; ++i) {
            Object next = this.stack[i];
            if (!next.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void push(T value) {
        int capacity = this.stack.length;
        if (this.count >= capacity) {
            Object[] copy = new Object[capacity * 2];
            if (this.count > 0) {
                System.arraycopy(this.stack, 0, copy, 0, this.stack.length);
            }
            this.stack = copy;
        }
        this.stack[this.count++] = value;
    }

    @Override
    public T pop() {
        if (this.count > 0) {
            return (T)this.stack[this.count-- - 1];
        }
        return null;
    }

    @Override
    public T peek() {
        if (this.count > 0) {
            return (T)this.stack[this.count - 1];
        }
        return null;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public void clear() {
        this.count = 0;
    }

    private class ArrayIterator
    implements Iterator<T> {
        public int index;

        public ArrayIterator(int index) {
            this.index = index;
        }

        @Override
        public boolean hasNext() {
            return this.index >= 0;
        }

        @Override
        public T next() {
            if (this.index >= 0) {
                return ArrayStack.this.stack[this.index--];
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported");
        }
    }
}

