/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.common;

import java.util.LinkedHashMap;
import java.util.Map;

public class LeastRecentlyUsedMap<K, V>
extends LinkedHashMap<K, V> {
    private final RemovalListener<K, V> removalListener;
    private final int capacity;

    public LeastRecentlyUsedMap() {
        this((RemovalListener<K, V>)null);
    }

    public LeastRecentlyUsedMap(int capacity) {
        this(null, capacity);
    }

    public LeastRecentlyUsedMap(RemovalListener<K, V> removalListener) {
        this(removalListener, 100);
    }

    public LeastRecentlyUsedMap(RemovalListener<K, V> removalListener, int capacity) {
        this.removalListener = removalListener;
        this.capacity = capacity;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        int size = this.size();
        if (size <= this.capacity) {
            return false;
        }
        if (this.removalListener != null) {
            V value = eldest.getValue();
            K key = eldest.getKey();
            this.removalListener.notifyRemoved(key, value);
        }
        return true;
    }

    public static interface RemovalListener<K, V> {
        public void notifyRemoved(K var1, V var2);
    }
}

