/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.common;

import java.lang.ref.SoftReference;
import java.util.Set;
import org.snapscript.common.Cache;
import org.snapscript.common.LeastRecentlyUsedCache;

public class SoftCache<K, V>
implements Cache<K, V> {
    private final Cache<K, SoftReference<V>> cache;

    public SoftCache() {
        this(100);
    }

    public SoftCache(int capacity) {
        this.cache = new LeastRecentlyUsedCache<K, SoftReference<V>>(capacity);
    }

    @Override
    public Set<K> keySet() {
        return this.cache.keySet();
    }

    @Override
    public V take(K key) {
        SoftReference<V> reference = this.cache.take(key);
        if (reference != null) {
            return reference.get();
        }
        return null;
    }

    @Override
    public V fetch(K key) {
        SoftReference<V> reference = this.cache.fetch(key);
        if (reference != null) {
            return reference.get();
        }
        return null;
    }

    @Override
    public void cache(K key, V value) {
        SoftReference<V> reference = new SoftReference<V>(value);
        if (value != null) {
            this.cache.cache(key, reference);
        }
    }

    @Override
    public boolean contains(K key) {
        SoftReference<V> reference = this.cache.fetch(key);
        if (reference != null) {
            return reference.get() != null;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public int size() {
        return this.cache.size();
    }
}

