/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.common;

import java.util.Iterator;

public class Vector<T>
implements Iterable<T> {
    private Node<T> first;
    private Node<T> last;
    private int size;

    @Override
    public Iterator<T> iterator() {
        return new NodeIterator<T>(this.first);
    }

    public T first() {
        if (this.first != null) {
            return (T)((Node)this.first).value;
        }
        return null;
    }

    public T last() {
        if (this.last != null) {
            return (T)((Node)this.last).value;
        }
        return null;
    }

    public T get(int index) {
        Node next = this.first;
        for (int i = 0; i < index; ++i) {
            if (next == null) {
                return null;
            }
            next = next.next;
        }
        return (T)next.value;
    }

    public void add(T value) {
        Node<T> node = new Node<T>(null, value);
        if (this.first == null) {
            this.first = node;
            this.last = node;
        } else {
            ((Node)this.last).next = (Node)node;
            this.last = node;
        }
        ++this.size;
    }

    public int size() {
        return this.size;
    }

    private static class Node<T> {
        private Node<T> next;
        private T value;

        public Node(Node<T> next, T value) {
            this.value = value;
            this.next = next;
        }
    }

    private static class NodeIterator<T>
    implements Iterator<T> {
        private Node<T> next;

        public NodeIterator(Node<T> next) {
            this.next = next;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            Object value = null;
            if (this.next != null) {
                value = ((Node)this.next).value;
                this.next = ((Node)this.next).next;
            }
            return (T)value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported");
        }
    }
}

