/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.common.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class CommandParser
implements Iterable<String> {
    private List<String> tokens = new ArrayList<String>();
    private StringBuilder token = new StringBuilder();
    private char[] source;
    private int count;
    private int off;

    public CommandParser(String command) {
        this.source = command.toCharArray();
        this.count = this.source.length;
    }

    public List<String> command() {
        if (this.tokens.isEmpty()) {
            this.parse();
        }
        return Collections.unmodifiableList(this.tokens);
    }

    @Override
    public Iterator<String> iterator() {
        return this.command().iterator();
    }

    private void parse() {
        this.seek();
        this.tokens();
    }

    private void tokens() {
        while (this.off < this.count) {
            char next = this.source[this.off];
            if (this.quote(next)) {
                this.literal();
            } else {
                this.value();
            }
            this.insert();
            this.seek();
        }
    }

    private void insert() {
        String value = this.token.toString();
        if (!value.isEmpty()) {
            this.tokens.add(value);
        }
        this.reset();
    }

    private void reset() {
        this.token.setLength(0);
    }

    private void seek() {
        while (this.off < this.count && this.space(this.source[this.off])) {
            ++this.off;
        }
    }

    private void value() {
        char next;
        while (this.off < this.count && !this.space(next = this.source[this.off++])) {
            this.token.append(next);
        }
    }

    private void literal() {
        char open = this.source[this.off];
        int start = this.off + 1;
        int length = 0;
        if (this.quote(open)) {
            ++this.off;
            while (this.off < this.count && open != this.source[this.off++]) {
            }
            length = this.off - start - 1;
        }
        if (length > 0) {
            this.token.append(this.source, start, length);
        }
    }

    private boolean quote(char value) {
        switch (value) {
            case '\"': 
            case '\'': {
                return true;
            }
        }
        return false;
    }

    private boolean space(char value) {
        switch (value) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }
}

