/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.common.command;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.snapscript.common.command.Environment;

public class MapEnvironment
implements Environment {
    private final Map<String, String> variables;

    public MapEnvironment(Map<String, String> variables) {
        this.variables = variables;
    }

    @Override
    public ProcessBuilder createProcess(String ... command) {
        return this.createProcess(Arrays.asList(command));
    }

    @Override
    public ProcessBuilder createProcess(List<String> command) {
        ProcessBuilder builder = new ProcessBuilder(command);
        if (!this.variables.isEmpty()) {
            Set<String> names = this.variables.keySet();
            for (String name : names) {
                String value = this.variables.get(name);
                builder.environment().put(name, value);
            }
        }
        return builder;
    }
}

