/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.common.store;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.snapscript.common.store.ClassPathStore;
import org.snapscript.common.store.Store;
import org.snapscript.common.store.StoreException;

public class FileStore
implements Store {
    private final ClassPathStore store = new ClassPathStore();
    private final File root;

    public FileStore(File root) {
        this.root = root;
    }

    @Override
    public InputStream getInputStream(String path) {
        File resource = new File(this.root, path);
        if (!resource.exists()) {
            return this.store.getInputStream(path);
        }
        try {
            return new FileInputStream(resource);
        }
        catch (Exception e) {
            throw new StoreException("Could not read resource '" + path + "'", e);
        }
    }

    @Override
    public OutputStream getOutputStream(String path) {
        File parent;
        File resource = new File(this.root, path);
        if (resource.exists()) {
            resource.delete();
        }
        if ((parent = resource.getParentFile()).exists()) {
            parent.mkdirs();
        }
        try {
            return new FileOutputStream(resource);
        }
        catch (Exception e) {
            throw new StoreException("Could not write resource '" + path + "'", e);
        }
    }
}

