/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.common.store;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import org.snapscript.common.store.RemoteStatus;
import org.snapscript.common.store.StoreException;

public class RemoteResponse {
    private final HttpURLConnection request;
    private final RemoteStatus status;
    private final String resource;

    public RemoteResponse(HttpURLConnection request, RemoteStatus status, String resource) {
        this.resource = resource;
        this.request = request;
        this.status = status;
    }

    public RemoteStatus getStatus() {
        try {
            return this.status;
        }
        catch (Exception e) {
            throw new StoreException("Could not determine status for " + this.resource, e);
        }
    }

    public InputStream getInputStream() {
        try {
            return this.request.getInputStream();
        }
        catch (Exception e) {
            throw new StoreException("Could not get input for " + this.resource, e);
        }
    }

    public OutputStream getOutputStream() {
        try {
            return this.request.getOutputStream();
        }
        catch (Exception e) {
            throw new StoreException("Could not get output for " + this.resource, e);
        }
    }
}

