/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.common.store;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.snapscript.common.store.NotFoundException;
import org.snapscript.common.store.RemoteClient;
import org.snapscript.common.store.RemoteResponse;
import org.snapscript.common.store.RemoteStatus;
import org.snapscript.common.store.Store;
import org.snapscript.common.store.StoreException;

public class RemoteStore
implements Store {
    private final RemoteClient client;
    private final URI root;

    public RemoteStore(URI root) {
        this.client = new RemoteClient(root);
        this.root = root;
    }

    @Override
    public InputStream getInputStream(String path) {
        RemoteResponse response = this.client.get(path);
        RemoteStatus status = response.getStatus();
        if (status.isNotFound()) {
            throw new NotFoundException("Could not find resource '" + path + "' from '" + this.root + "'");
        }
        if (status.isError()) {
            throw new StoreException("Error reading resource '" + path + "' from '" + this.root + "'");
        }
        return response.getInputStream();
    }

    @Override
    public OutputStream getOutputStream(String path) {
        RemoteResponse response = this.client.put(path);
        RemoteStatus status = response.getStatus();
        if (status.isError()) {
            throw new StoreException("Error writing resource '" + path + "' to '" + this.root + "'");
        }
        return response.getOutputStream();
    }
}

