/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.common.store;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import org.snapscript.common.store.Store;
import org.snapscript.common.store.StoreException;

public class StoreReader {
    private final Store store;
    private final int read;

    public StoreReader(Store store) {
        this(store, 8192);
    }

    public StoreReader(Store store, int read) {
        this.store = store;
        this.read = read;
    }

    public byte[] getBytes(String path) {
        InputStream source = this.store.getInputStream(path);
        try {
            if (source != null) {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream(this.read);
                byte[] array = new byte[this.read];
                int count = 0;
                while ((count = source.read(array)) != -1) {
                    buffer.write(array, 0, count);
                }
                return buffer.toByteArray();
            }
        }
        catch (Exception e) {
            throw new StoreException("Could not read resource '" + path + "'", e);
        }
        return null;
    }
}

