/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.common.thread;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadBuilder
implements ThreadFactory {
    private static final String THREAD_TEMPLATE = "%s: Thread-%s";
    private static final String THREAD_DEFAULT = "Thread";
    private final ThreadNameBuilder builder = new ThreadNameBuilder();
    private final boolean daemon;
    private final int stack;

    public ThreadBuilder() {
        this(true);
    }

    public ThreadBuilder(boolean daemon) {
        this(daemon, 0);
    }

    public ThreadBuilder(boolean daemon, int stack) {
        this.daemon = daemon;
        this.stack = stack;
    }

    @Override
    public Thread newThread(Runnable task) {
        Thread thread = new Thread(null, task, THREAD_DEFAULT, this.stack);
        if (task != null) {
            String name = this.builder.createName(task);
            thread.setDaemon(this.daemon);
            thread.setName(name);
        }
        return thread;
    }

    public Thread newThread(Runnable task, Class type) {
        Thread thread = new Thread(null, task, THREAD_DEFAULT, this.stack);
        if (task != null) {
            String name = this.builder.createName(type);
            thread.setDaemon(this.daemon);
            thread.setName(name);
        }
        return thread;
    }

    private class ThreadNameBuilder {
        private final AtomicInteger counter = new AtomicInteger(1);

        private String createName(Runnable task) {
            Class<?> type = task.getClass();
            String prefix = type.getSimpleName();
            int count = this.counter.getAndIncrement();
            return String.format(ThreadBuilder.THREAD_TEMPLATE, prefix, count);
        }

        private String createName(Class type) {
            String prefix = type.getSimpleName();
            int count = this.counter.getAndIncrement();
            return String.format(ThreadBuilder.THREAD_TEMPLATE, prefix, count);
        }
    }
}

