/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.compile;

import org.snapscript.common.Cache;
import org.snapscript.common.LeastRecentlyUsedCache;
import org.snapscript.compile.Compiler;
import org.snapscript.compile.Executable;
import org.snapscript.compile.assemble.Program;
import org.snapscript.core.Context;
import org.snapscript.core.FilePathConverter;
import org.snapscript.core.Path;
import org.snapscript.core.PathConverter;
import org.snapscript.core.ResourceManager;
import org.snapscript.core.link.Package;
import org.snapscript.core.link.PackageLinker;
import org.snapscript.tree.Instruction;

public class ResourceCompiler
implements Compiler {
    private final Cache<String, Executable> cache = new LeastRecentlyUsedCache<String, Executable>();
    private final PathConverter converter = new FilePathConverter();
    private final Context context;

    public ResourceCompiler(Context context) {
        this.context = context;
    }

    @Override
    public Executable compile(String resource) throws Exception {
        if (resource == null) {
            throw new NullPointerException("No resource provided");
        }
        Executable executable = this.cache.fetch(resource);
        if (executable == null) {
            ResourceManager manager = this.context.getManager();
            String module = this.converter.createModule(resource);
            Path path = this.converter.createPath(resource);
            String source = manager.getString(resource);
            if (source == null) {
                throw new IllegalArgumentException("Resource '" + resource + "' not found");
            }
            PackageLinker linker = this.context.getLinker();
            Package library = linker.link(path, source, Instruction.SCRIPT.name);
            return new Program(this.context, library, path, module);
        }
        return executable;
    }
}

