/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.compile;

import org.snapscript.common.Cache;
import org.snapscript.common.LeastRecentlyUsedCache;
import org.snapscript.compile.Compiler;
import org.snapscript.compile.Executable;
import org.snapscript.compile.assemble.Program;
import org.snapscript.core.Context;
import org.snapscript.core.FilePathConverter;
import org.snapscript.core.Path;
import org.snapscript.core.PathConverter;
import org.snapscript.core.link.Package;
import org.snapscript.core.link.PackageLinker;
import org.snapscript.tree.Instruction;

public class StringCompiler
implements Compiler {
    private final Cache<String, Executable> cache = new LeastRecentlyUsedCache<String, Executable>();
    private final PathConverter converter = new FilePathConverter();
    private final Context context;
    private final String module;

    public StringCompiler(Context context) {
        this(context, "default");
    }

    public StringCompiler(Context context, String module) {
        this.context = context;
        this.module = module;
    }

    @Override
    public Executable compile(String source) throws Exception {
        if (source == null) {
            throw new NullPointerException("No source provided");
        }
        Executable executable = this.cache.fetch(source);
        if (executable == null) {
            Path path = this.converter.createPath(this.module);
            PackageLinker linker = this.context.getLinker();
            Package library = linker.link(path, source, Instruction.SCRIPT.name);
            return new Program(this.context, library, path, this.module);
        }
        return executable;
    }
}

