/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.compile.assemble;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import org.snapscript.common.Cache;
import org.snapscript.common.LeastRecentlyUsedCache;
import org.snapscript.compile.assemble.Assembler;
import org.snapscript.core.Evaluation;
import org.snapscript.core.FilePathConverter;
import org.snapscript.core.Path;
import org.snapscript.core.PathConverter;
import org.snapscript.parse.SyntaxCompiler;
import org.snapscript.parse.SyntaxNode;
import org.snapscript.parse.SyntaxParser;
import org.snapscript.tree.Instruction;

public class EvaluationBuilder {
    private final Cache<String, Evaluation> cache = new LeastRecentlyUsedCache<String, Evaluation>();
    private final PathConverter converter;
    private final SyntaxCompiler compiler = new SyntaxCompiler("grammar.bnf");
    private final Assembler assembler;
    private final Executor executor;
    private final int limit;

    public EvaluationBuilder(Assembler assembler, Executor executor) {
        this(assembler, executor, 200);
    }

    public EvaluationBuilder(Assembler assembler, Executor executor, int limit) {
        this.converter = new FilePathConverter();
        this.assembler = assembler;
        this.executor = executor;
        this.limit = limit;
    }

    public Evaluation create(String source, String module) throws Exception {
        Evaluation evaluation = this.cache.fetch(source);
        if (evaluation == null) {
            Executable executable = new Executable(source, module);
            FutureTask<Evaluation> task = new FutureTask<Evaluation>(executable);
            if (this.executor != null) {
                this.executor.execute(task);
            } else {
                task.run();
            }
            return task.get();
        }
        return evaluation;
    }

    private class Executable
    implements Callable<Evaluation> {
        private final String source;
        private final String module;

        public Executable(String source, String module) {
            this.source = source;
            this.module = module;
        }

        @Override
        public Evaluation call() throws Exception {
            SyntaxParser parser = EvaluationBuilder.this.compiler.compile();
            SyntaxNode node = parser.parse(this.module, this.source, Instruction.EXPRESSION.name);
            Path path = EvaluationBuilder.this.converter.createPath(this.module);
            Evaluation evaluation = (Evaluation)EvaluationBuilder.this.assembler.assemble(node, path);
            int length = this.source.length();
            if (length < EvaluationBuilder.this.limit) {
                EvaluationBuilder.this.cache.cache(this.source, evaluation);
            }
            return evaluation;
        }
    }
}

