/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.compile.assemble;

import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import org.snapscript.compile.assemble.ProgramLinker;
import org.snapscript.core.Context;
import org.snapscript.core.Path;
import org.snapscript.core.link.ExceptionPackage;
import org.snapscript.core.link.FuturePackage;
import org.snapscript.core.link.Package;
import org.snapscript.core.link.PackageLinker;

public class ExecutorLinker
implements PackageLinker {
    private final ConcurrentMap<Path, Package> registry = new ConcurrentHashMap<Path, Package>();
    private final PackageLinker linker;
    private final Executor executor;

    public ExecutorLinker(Context context) {
        this(context, null);
    }

    public ExecutorLinker(Context context, Executor executor) {
        this.linker = new ProgramLinker(context);
        this.executor = executor;
    }

    @Override
    public Package link(Path path, String source) throws Exception {
        if (this.executor != null) {
            Executable executable = new Executable(path, source);
            FutureTask<Package> task = new FutureTask<Package>(executable);
            FuturePackage result = new FuturePackage(task, path);
            if (this.registry.putIfAbsent(path, result) == null) {
                this.executor.execute(task);
                return result;
            }
            return (Package)this.registry.get(path);
        }
        return this.linker.link(path, source);
    }

    @Override
    public Package link(Path path, String source, String grammar) throws Exception {
        if (this.executor != null) {
            Executable executable = new Executable(path, source, grammar);
            FutureTask<Package> task = new FutureTask<Package>(executable);
            FuturePackage result = new FuturePackage(task, path);
            if (this.registry.putIfAbsent(path, result) == null) {
                this.executor.execute(task);
                return result;
            }
            return (Package)this.registry.get(path);
        }
        return this.linker.link(path, source, grammar);
    }

    private class Executable
    implements Callable<Package> {
        private final String grammar;
        private final String source;
        private final Path path;

        public Executable(Path path, String source) {
            this(path, source, null);
        }

        public Executable(Path path, String source, String grammar) {
            this.grammar = grammar;
            this.source = source;
            this.path = path;
        }

        @Override
        public Package call() {
            try {
                if (this.grammar != null) {
                    return ExecutorLinker.this.linker.link(this.path, this.source, this.grammar);
                }
                return ExecutorLinker.this.linker.link(this.path, this.source);
            }
            catch (Exception cause) {
                return new ExceptionPackage("Could not link '" + this.path + "'", cause);
            }
        }
    }
}

