/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.compile.assemble;

import java.util.concurrent.Executor;
import org.snapscript.compile.assemble.Assembler;
import org.snapscript.compile.assemble.EvaluationBuilder;
import org.snapscript.compile.assemble.OperationAssembler;
import org.snapscript.core.Context;
import org.snapscript.core.Evaluation;
import org.snapscript.core.ExpressionEvaluator;
import org.snapscript.core.InternalStateException;
import org.snapscript.core.Model;
import org.snapscript.core.Scope;
import org.snapscript.core.ScopeMerger;
import org.snapscript.core.Value;

public class OperationEvaluator
implements ExpressionEvaluator {
    private final EvaluationBuilder builder;
    private final ScopeMerger merger;
    private final Assembler assembler;

    public OperationEvaluator(Context context, Executor executor) {
        this(context, executor, 200);
    }

    public OperationEvaluator(Context context, Executor executor, int limit) {
        this.assembler = new OperationAssembler(context);
        this.builder = new EvaluationBuilder(this.assembler, executor, limit);
        this.merger = new ScopeMerger(context);
    }

    @Override
    public <T> T evaluate(Model model, String source) throws Exception {
        return this.evaluate(model, source, "default");
    }

    @Override
    public <T> T evaluate(Model model, String source, String module) throws Exception {
        Scope scope = this.merger.merge(model, module);
        return this.evaluate(scope, source, module);
    }

    @Override
    public <T> T evaluate(Scope scope, String source) throws Exception {
        return this.evaluate(scope, source, "default");
    }

    @Override
    public <T> T evaluate(Scope scope, String source, String module) throws Exception {
        try {
            Evaluation evaluation = this.builder.create(source, module);
            Value reference = evaluation.evaluate(scope, null);
            return reference.getValue();
        }
        catch (Exception e) {
            throw new InternalStateException("Could not evaluate '" + source + "'", e);
        }
    }
}

