/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.compile.assemble;

import org.snapscript.compile.assemble.Assembler;
import org.snapscript.compile.assemble.OperationAssembler;
import org.snapscript.core.Context;
import org.snapscript.core.FilePathConverter;
import org.snapscript.core.Path;
import org.snapscript.core.PathConverter;
import org.snapscript.core.Statement;
import org.snapscript.core.link.Package;
import org.snapscript.core.link.StatementPackage;
import org.snapscript.parse.SyntaxCompiler;
import org.snapscript.parse.SyntaxNode;
import org.snapscript.parse.SyntaxParser;

public class PackageBuilder {
    private final SyntaxCompiler compiler = new SyntaxCompiler("grammar.bnf");
    private final PathConverter converter;
    private final Assembler assembler;

    public PackageBuilder(Context context) {
        this.assembler = new OperationAssembler(context);
        this.converter = new FilePathConverter();
    }

    public Package create(Path path, String source, String grammar) throws Exception {
        String resource = path.getPath();
        SyntaxParser parser = this.compiler.compile();
        SyntaxNode node = parser.parse(resource, source, grammar);
        Statement statement = (Statement)this.assembler.assemble(node, path);
        String module = this.converter.createModule(resource);
        return new StatementPackage(statement, path, module);
    }
}

