/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.compile.assemble;

import org.snapscript.common.Cache;
import org.snapscript.common.LeastRecentlyUsedCache;
import org.snapscript.compile.assemble.PackageBuilder;
import org.snapscript.core.Context;
import org.snapscript.core.Path;
import org.snapscript.core.link.Package;
import org.snapscript.core.link.PackageLinker;
import org.snapscript.tree.Instruction;

public class ProgramLinker
implements PackageLinker {
    private final Cache<Path, Package> cache = new LeastRecentlyUsedCache<Path, Package>();
    private final PackageBuilder builder;

    public ProgramLinker(Context context) {
        this.builder = new PackageBuilder(context);
    }

    @Override
    public Package link(Path path, String source) throws Exception {
        return this.link(path, source, Instruction.SCRIPT_PACKAGE.name);
    }

    @Override
    public Package link(Path path, String source, String grammar) throws Exception {
        Package linked = this.cache.fetch(path);
        if (linked == null) {
            linked = this.builder.create(path, source, grammar);
            this.cache.cache(path, linked);
        }
        return linked;
    }
}

