/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.compile.validate;

import java.util.List;
import java.util.Set;
import org.snapscript.core.InternalStateException;
import org.snapscript.core.ModifierType;
import org.snapscript.core.Type;
import org.snapscript.core.TypeExtractor;
import org.snapscript.core.convert.ConstraintMatcher;
import org.snapscript.core.convert.FunctionComparator;
import org.snapscript.core.convert.Score;
import org.snapscript.core.function.Function;
import org.snapscript.tree.ModifierValidator;

public class FunctionValidator {
    private final FunctionComparator comparator;
    private final ModifierValidator validator;
    private final TypeExtractor extractor;

    public FunctionValidator(ConstraintMatcher matcher, TypeExtractor extractor) {
        this.comparator = new FunctionComparator(matcher);
        this.validator = new ModifierValidator();
        this.extractor = extractor;
    }

    public void validate(Function function) throws Exception {
        Type type = function.getType();
        if (type == null) {
            throw new InternalStateException("Function '" + function + "' does not have a type");
        }
        this.validateModifiers(function);
    }

    private void validateModifiers(Function function) throws Exception {
        Type actual = function.getType();
        int modifiers = function.getModifiers();
        if (ModifierType.isOverride(modifiers)) {
            Set<Type> types = this.extractor.getTypes(actual);
            int matches = 0;
            for (Type type : types) {
                List<Function> functions;
                Score score;
                if (type == actual || (score = this.comparator.compare(function, functions = type.getFunctions())).compareTo(Score.INVALID) == 0) continue;
                ++matches;
                break;
            }
            if (matches == 0) {
                throw new InternalStateException("Function '" + function + "' is not an override");
            }
        }
        this.validator.validate(actual, function, modifiers);
    }
}

