/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.compile.validate;

import org.snapscript.core.InternalStateException;
import org.snapscript.core.Type;
import org.snapscript.core.convert.ConstraintMatcher;
import org.snapscript.core.property.Property;
import org.snapscript.tree.ModifierValidator;

public class PropertyValidator {
    private final ModifierValidator validator = new ModifierValidator();
    private final String[] ignores;

    public PropertyValidator(ConstraintMatcher matcher) {
        this(matcher, "class", "this", "name", "ordinal", "values");
    }

    public PropertyValidator(ConstraintMatcher matcher, String ... ignores) {
        this.ignores = ignores;
    }

    public void validate(Property property) throws Exception {
        Type type = property.getType();
        String name = property.getName();
        int modifiers = property.getModifiers();
        int matches = 0;
        for (String ignore : this.ignores) {
            if (!ignore.equals(name)) continue;
            ++matches;
        }
        if (matches == 0) {
            if (type == null) {
                throw new InternalStateException("Property '" + property + "' does not have a type");
            }
            this.validator.validate(type, property, modifiers);
        }
    }
}

