/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.compile.validate;

import java.util.List;
import java.util.Set;
import org.snapscript.compile.validate.FunctionValidator;
import org.snapscript.compile.validate.PropertyValidator;
import org.snapscript.core.InternalStateException;
import org.snapscript.core.Module;
import org.snapscript.core.Type;
import org.snapscript.core.TypeExtractor;
import org.snapscript.core.convert.ConstraintMatcher;
import org.snapscript.core.function.Function;
import org.snapscript.core.property.Property;

public class TypeValidator {
    private static final String[] PROPERTIES = new String[]{"this", "class"};
    private static final String[] TYPES = new String[]{"Any"};
    private final PropertyValidator properties;
    private final FunctionValidator functions;
    private final TypeExtractor extractor;

    public TypeValidator(ConstraintMatcher matcher, TypeExtractor extractor) {
        this.functions = new FunctionValidator(matcher, extractor);
        this.properties = new PropertyValidator(matcher);
        this.extractor = extractor;
    }

    public void validate(Type type) throws Exception {
        Class real = type.getType();
        if (real == null) {
            this.validateModule(type);
            this.validateHierarchy(type);
            this.validateFunctions(type);
            this.validateProperties(type);
        }
    }

    private void validateModule(Type type) throws Exception {
        Module module = type.getModule();
        if (module == null) {
            throw new InternalStateException("Type '" + type + "' has no module");
        }
    }

    private void validateHierarchy(Type type) throws Exception {
        Set<Type> types = this.extractor.getTypes(type);
        for (int i = 0; i < TYPES.length; ++i) {
            String require = TYPES[i];
            int matches = 0;
            for (Type base : types) {
                String name = base.getName();
                if (!name.equals(require)) continue;
                ++matches;
            }
            if (matches != 0) continue;
            throw new InternalStateException("Type '" + type + "' has an invalid hierarchy");
        }
    }

    private void validateProperties(Type type) throws Exception {
        List<Property> list = type.getProperties();
        for (int i = 0; i < PROPERTIES.length; ++i) {
            String require = PROPERTIES[i];
            int matches = 0;
            for (Property property : list) {
                String name = property.getName();
                if (name.equals(require)) {
                    ++matches;
                }
                this.properties.validate(property);
            }
            if (matches != 0) continue;
            throw new InternalStateException("Type '" + type + "' has no property '" + require + "'");
        }
    }

    private void validateFunctions(Type type) throws Exception {
        List<Function> list = type.getFunctions();
        for (Function function : list) {
            String name = function.getName();
            if (name.equals("new")) continue;
            this.functions.validate(function);
        }
    }
}

