/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core;

import org.snapscript.core.MapState;
import org.snapscript.core.Model;
import org.snapscript.core.Module;
import org.snapscript.core.Scope;
import org.snapscript.core.State;
import org.snapscript.core.Type;

public class CompoundScope
implements Scope {
    private final State state;
    private final Scope outer;
    private final Model model;

    public CompoundScope(Model model, Scope inner, Scope outer) {
        this.state = new MapState(model, inner);
        this.outer = outer;
        this.model = model;
    }

    @Override
    public Scope getInner() {
        return new StateScope(this.model, this, this.outer);
    }

    @Override
    public Scope getOuter() {
        return this.outer;
    }

    @Override
    public Type getHandle() {
        return this.outer.getType();
    }

    @Override
    public Type getType() {
        return this.outer.getType();
    }

    @Override
    public Module getModule() {
        return this.outer.getModule();
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public State getState() {
        return this.state;
    }

    @Override
    public String toString() {
        return String.valueOf(this.state);
    }

    private static class StateScope
    implements Scope {
        private final State state;
        private final Scope outer;
        private final Model model;

        public StateScope(Model model, Scope inner, Scope outer) {
            this.state = new MapState(null, inner);
            this.outer = outer;
            this.model = model;
        }

        @Override
        public Scope getInner() {
            return new StateScope(this.model, this, this.outer);
        }

        @Override
        public Scope getOuter() {
            return this.outer;
        }

        @Override
        public Type getHandle() {
            return this.outer.getType();
        }

        @Override
        public Type getType() {
            return this.outer.getType();
        }

        @Override
        public Module getModule() {
            return this.outer.getModule();
        }

        @Override
        public Model getModel() {
            return this.model;
        }

        @Override
        public State getState() {
            return this.state;
        }

        @Override
        public String toString() {
            return String.valueOf(this.state);
        }
    }
}

