/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.snapscript.core.Context;
import org.snapscript.core.Module;
import org.snapscript.core.ModuleException;
import org.snapscript.core.ModuleScope;
import org.snapscript.core.Path;
import org.snapscript.core.ResourceManager;
import org.snapscript.core.Scope;
import org.snapscript.core.Type;
import org.snapscript.core.TypeLoader;
import org.snapscript.core.annotation.Annotation;
import org.snapscript.core.function.Function;
import org.snapscript.core.link.ImportManager;

public class ContextModule
implements Module {
    private final Map<String, Module> modules;
    private final List<Annotation> annotations;
    private final Map<String, Type> types;
    private final List<Function> functions;
    private final List<Type> references;
    private final ImportManager manager;
    private final Context context;
    private final String prefix;
    private final Scope scope;
    private final Path path;
    private final int order;

    public ContextModule(Context context, Path path, String prefix) {
        this(context, path, prefix, 0);
    }

    public ContextModule(Context context, Path path, String prefix, int order) {
        this.manager = new ImportManager(this, path, prefix);
        this.annotations = new CopyOnWriteArrayList<Annotation>();
        this.functions = new CopyOnWriteArrayList<Function>();
        this.modules = new ConcurrentHashMap<String, Module>();
        this.types = new ConcurrentHashMap<String, Type>();
        this.references = new CopyOnWriteArrayList<Type>();
        this.scope = new ModuleScope(this);
        this.context = context;
        this.prefix = prefix;
        this.order = order;
        this.path = path;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public ImportManager getManager() {
        return this.manager;
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public List<Function> getFunctions() {
        return this.functions;
    }

    @Override
    public List<Type> getTypes() {
        return this.references;
    }

    @Override
    public Type addType(String name) {
        Type type = this.types.get(name);
        if (type != null) {
            throw new ModuleException("Type '" + this.prefix + "." + name + "' already defined");
        }
        try {
            TypeLoader loader = this.context.getLoader();
            if (loader != null) {
                type = loader.defineType(this.prefix, name);
            }
            if (type != null) {
                this.types.put(name, type);
                this.references.add(type);
            }
            return type;
        }
        catch (Exception e) {
            throw new ModuleException("Could not define '" + this.prefix + "." + name + "'", e);
        }
    }

    @Override
    public Module getModule(String name) {
        try {
            Module module = this.modules.get(name);
            if (module == null && !this.types.containsKey(name) && (module = this.manager.getModule(name)) != null) {
                this.modules.put(name, module);
            }
            return module;
        }
        catch (Exception e) {
            throw new ModuleException("Could not find '" + name + "' in '" + this.prefix + "'", e);
        }
    }

    @Override
    public Type getType(String name) {
        try {
            Type type = this.types.get(name);
            if (type == null && !this.modules.containsKey(name) && (type = this.manager.getType(name)) != null) {
                this.types.put(name, type);
                this.references.add(type);
            }
            return type;
        }
        catch (Exception e) {
            throw new ModuleException("Could not find '" + name + "' in '" + this.prefix + "'", e);
        }
    }

    @Override
    public Type getType(Class type) {
        try {
            TypeLoader loader = this.context.getLoader();
            if (loader != null) {
                return loader.loadType(type);
            }
            return null;
        }
        catch (Exception e) {
            throw new ModuleException("Could not load " + type, e);
        }
    }

    @Override
    public InputStream getResource(String path) {
        try {
            ResourceManager manager = this.context.getManager();
            if (manager != null) {
                return manager.getInputStream(path);
            }
            return null;
        }
        catch (Exception e) {
            throw new ModuleException("Could not load file '" + path + "'", e);
        }
    }

    @Override
    public Scope getScope() {
        return this.scope;
    }

    @Override
    public String getName() {
        return this.prefix;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public String toString() {
        return this.prefix;
    }
}

