/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.snapscript.common.CompoundIterator;
import org.snapscript.core.InternalStateException;
import org.snapscript.core.Model;
import org.snapscript.core.Scope;
import org.snapscript.core.State;
import org.snapscript.core.Value;
import org.snapscript.core.ValueType;

public class MapState
implements State {
    private final Map<String, Value> values = new HashMap<String, Value>();
    private final Scope scope;
    private final Model model;

    public MapState() {
        this(null);
    }

    public MapState(Model model) {
        this(model, null);
    }

    public MapState(Model model, Scope scope) {
        this.model = model;
        this.scope = scope;
    }

    @Override
    public Iterator<String> iterator() {
        Set<String> keys = this.values.keySet();
        Iterator<String> inner = keys.iterator();
        if (this.scope != null) {
            State state = this.scope.getState();
            Iterator outer = state.iterator();
            return new CompoundIterator<String>(inner, outer);
        }
        return inner;
    }

    @Override
    public Value get(String name) {
        Object object;
        Value value = this.values.get(name);
        if (value == null && this.scope != null) {
            State state = this.scope.getState();
            if (state == null) {
                throw new InternalStateException("Scope for '" + name + "' does not exist");
            }
            value = state.get(name);
        }
        if (value == null && this.model != null && (object = this.model.getAttribute(name)) != null) {
            return ValueType.getConstant(object);
        }
        return value;
    }

    @Override
    public void add(String name, Value value) {
        Value variable = this.values.get(name);
        if (variable != null) {
            throw new InternalStateException("Variable '" + name + "' already exists");
        }
        this.values.put(name, value);
    }

    public String toString() {
        return String.valueOf(this.values);
    }
}

