/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core;

public enum ModifierType {
    STATIC("static", 1),
    OVERRIDE("override", 2),
    PRIVATE("private", 4),
    PUBLIC("public", 8),
    PROTECTED("protected", 16),
    CONSTANT("const", 32),
    VARIABLE("var", 64),
    ABSTRACT("abstract", 128),
    VARARGS("...", 256);

    public final String token;
    public final int mask;

    private ModifierType(String token, int mask) {
        this.token = token;
        this.mask = mask;
    }

    public static boolean isDefault(int modifier) {
        return modifier == -1;
    }

    public static boolean isStatic(int modifier) {
        return modifier >= 0 && (ModifierType.STATIC.mask & modifier) != 0;
    }

    public static boolean isConstant(int modifier) {
        return modifier >= 0 && (ModifierType.CONSTANT.mask & modifier) != 0;
    }

    public static boolean isVariable(int modifier) {
        return modifier >= 0 && (ModifierType.VARIABLE.mask & modifier) != 0;
    }

    public static boolean isOverride(int modifier) {
        return modifier >= 0 && (ModifierType.OVERRIDE.mask & modifier) != 0;
    }

    public static boolean isAbstract(int modifier) {
        return modifier >= 0 && (ModifierType.ABSTRACT.mask & modifier) != 0;
    }

    public static boolean isPublic(int modifier) {
        return modifier >= 0 && (ModifierType.PUBLIC.mask & modifier) != 0;
    }

    public static boolean isPrivate(int modifier) {
        return modifier >= 0 && (ModifierType.PRIVATE.mask & modifier) != 0;
    }

    public static boolean isProtected(int modifier) {
        return modifier >= 0 && (ModifierType.PROTECTED.mask & modifier) != 0;
    }

    public static boolean isVariableArgument(int modifier) {
        return modifier >= 0 && (ModifierType.VARARGS.mask & modifier) != 0;
    }

    public static ModifierType resolveModifier(String token) {
        ModifierType[] modifiers;
        for (ModifierType modifier : modifiers = ModifierType.values()) {
            if (!modifier.token.equals(token)) continue;
            return modifier;
        }
        return null;
    }
}

