/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.snapscript.core.Context;
import org.snapscript.core.ContextModule;
import org.snapscript.core.FilePathConverter;
import org.snapscript.core.InternalArgumentException;
import org.snapscript.core.InternalStateException;
import org.snapscript.core.Module;
import org.snapscript.core.Path;
import org.snapscript.core.PathConverter;
import org.snapscript.core.extend.ModuleExtender;

public class ModuleRegistry {
    private final Map<String, Module> modules = new ConcurrentHashMap<String, Module>();
    private final List<Module> references = new CopyOnWriteArrayList<Module>();
    private final PathConverter converter;
    private final ModuleExtender extender;
    private final AtomicInteger counter;
    private final Context context;
    private final int limit;

    public ModuleRegistry(Context context) {
        this(context, 100000);
    }

    public ModuleRegistry(Context context, int limit) {
        this.extender = new ModuleExtender(context);
        this.converter = new FilePathConverter();
        this.counter = new AtomicInteger(1);
        this.context = context;
        this.limit = limit;
    }

    public synchronized List<Module> getModules() {
        return this.references;
    }

    public synchronized Module getModule(String name) {
        if (name == null) {
            throw new InternalArgumentException("Module name was null");
        }
        return this.modules.get(name);
    }

    public synchronized Module addModule(String name) {
        if (name == null) {
            throw new InternalArgumentException("Module name was null");
        }
        Path path = this.converter.createPath(name);
        Module current = this.modules.get(name);
        if (current == null) {
            return this.addModule(name, path);
        }
        return current;
    }

    public synchronized Module addModule(String name, Path path) {
        if (name == null) {
            throw new InternalArgumentException("Module name was null");
        }
        Module current = this.modules.get(name);
        if (current == null) {
            int order = this.counter.getAndIncrement();
            if (order > this.limit) {
                throw new InternalStateException("Module limit of " + this.limit + " exceeded");
            }
            ContextModule module = new ContextModule(this.context, path, name, order);
            this.modules.put(name, module);
            this.extender.extend(module);
            this.references.add(module);
            return module;
        }
        return current;
    }
}

