/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core;

import org.snapscript.core.ResultType;

public class Result {
    public static final Result NORMAL_RESULT = new Result(ResultType.NORMAL);
    public static final Result RETURN_RESULT = new Result(ResultType.RETURN);
    public static final Result BREAK_RESULT = new Result(ResultType.BREAK);
    public static final Result CONTINUE_RESULT = new Result(ResultType.CONTINUE);
    public static final Result THROW_RESULT = new Result(ResultType.THROW);
    public static final Result DECLARE_RESULT = new Result(ResultType.DECLARE);
    private final ResultType type;
    private final Object value;

    public Result(ResultType type) {
        this(type, null);
    }

    public Result(ResultType type, Object value) {
        this.value = value;
        this.type = type;
    }

    public boolean isDeclare() {
        return this.type == ResultType.DECLARE;
    }

    public boolean isReturn() {
        return this.type == ResultType.RETURN;
    }

    public boolean isNormal() {
        return this.type == ResultType.NORMAL || this.type == ResultType.DECLARE;
    }

    public boolean isBreak() {
        return this.type == ResultType.BREAK;
    }

    public boolean isThrow() {
        return this.type == ResultType.THROW;
    }

    public boolean isContinue() {
        return this.type == ResultType.CONTINUE;
    }

    public ResultType getType() {
        return this.type;
    }

    public <T> T getValue() {
        return (T)this.value;
    }
}

