/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core;

import org.snapscript.core.Context;
import org.snapscript.core.FilePathConverter;
import org.snapscript.core.InternalStateException;
import org.snapscript.core.Model;
import org.snapscript.core.ModelScope;
import org.snapscript.core.Module;
import org.snapscript.core.ModuleRegistry;
import org.snapscript.core.Path;
import org.snapscript.core.PathConverter;
import org.snapscript.core.Scope;

public class ScopeMerger {
    private final PathConverter converter = new FilePathConverter();
    private final Context context;

    public ScopeMerger(Context context) {
        this.context = context;
    }

    public Scope merge(Model model, String name) {
        Path path = this.converter.createPath(name);
        if (path == null) {
            throw new InternalStateException("Module '" + name + "' does not have a path");
        }
        return this.merge(model, name, path);
    }

    public Scope merge(Model model, String name, Path path) {
        ModuleRegistry registry = this.context.getRegistry();
        Module module = registry.addModule(name, path);
        if (module == null) {
            throw new InternalStateException("Module '" + name + "' not found");
        }
        return new ModelScope(model, module);
    }
}

