/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core;

import org.snapscript.common.Cache;
import org.snapscript.common.CopyOnWriteCache;
import org.snapscript.common.CopyOnWriteSparseArray;
import org.snapscript.common.SparseArray;
import org.snapscript.core.Type;

public class TypeCache<V> {
    private final SparseArray<V> array;
    private final Cache<Type, V> cache;

    public TypeCache() {
        this(1000);
    }

    public TypeCache(int capacity) {
        this.array = new CopyOnWriteSparseArray<V>(capacity);
        this.cache = new CopyOnWriteCache<Type, V>();
    }

    public V take(Type type) {
        int order = type.getOrder();
        if (order == 0) {
            return this.cache.take(type);
        }
        return this.array.remove(order);
    }

    public V fetch(Type type) {
        int order = type.getOrder();
        if (order == 0) {
            return this.cache.fetch(type);
        }
        return this.array.get(order);
    }

    public boolean contains(Type type) {
        int order = type.getOrder();
        if (order == 0) {
            return this.cache.contains(type);
        }
        return this.array.get(order) != null;
    }

    public void cache(Type type, V value) {
        int order = type.getOrder();
        if (order == 0) {
            this.cache.cache(type, value);
        }
        this.array.set(order, value);
    }
}

