/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core;

import java.util.Set;
import org.snapscript.core.Type;
import org.snapscript.core.TypeExtractor;
import org.snapscript.core.TypeLoader;
import org.snapscript.core.closure.ClosureFunctionFinder;
import org.snapscript.core.convert.ConstraintMatcher;
import org.snapscript.core.convert.FunctionComparator;
import org.snapscript.core.convert.Score;
import org.snapscript.core.function.Function;

public class TypeCastChecker {
    private final FunctionComparator comparator;
    private final ClosureFunctionFinder finder;
    private final TypeExtractor extractor;
    private final TypeLoader loader;

    public TypeCastChecker(ConstraintMatcher matcher, TypeExtractor extractor, TypeLoader loader) {
        this.comparator = new FunctionComparator(matcher);
        this.finder = new ClosureFunctionFinder(loader);
        this.extractor = extractor;
        this.loader = loader;
    }

    public Score cast(Class actual, Type constraint) throws Exception {
        Type type = this.loader.loadType(actual);
        if (!actual.equals(constraint)) {
            return this.cast(type, constraint);
        }
        return Score.EXACT;
    }

    public Score cast(Type actual, Type constraint) throws Exception {
        if (!actual.equals(constraint)) {
            Set<Type> list = this.extractor.getTypes(actual);
            if (list.isEmpty()) {
                return Score.INVALID;
            }
            if (list.contains(constraint)) {
                return Score.SIMILAR;
            }
            return Score.INVALID;
        }
        return Score.EXACT;
    }

    public Score cast(Type type, Type constraint, Object value) throws Exception {
        if (Function.class.isInstance(value)) {
            Class real = constraint.getType();
            Function require = null;
            require = real != null ? this.finder.find(real) : this.finder.find(constraint);
            if (require != null) {
                return this.comparator.compare((Function)value, require);
            }
        }
        return this.cast(type, constraint);
    }
}

