/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core;

import java.util.Set;
import org.snapscript.common.Cache;
import org.snapscript.common.CopyOnWriteCache;
import org.snapscript.core.Handle;
import org.snapscript.core.Type;
import org.snapscript.core.TypeLoader;
import org.snapscript.core.TypeTraverser;

public class TypeExtractor {
    private final Cache<Class, Type> matches = new CopyOnWriteCache<Class, Type>();
    private final TypeTraverser traverser = new TypeTraverser();
    private final TypeLoader loader;

    public TypeExtractor(TypeLoader loader) {
        this.loader = loader;
    }

    public Type getType(Object value) {
        if (value != null) {
            Class<?> type = value.getClass();
            if (Handle.class.isAssignableFrom(type)) {
                Handle handle = (Handle)value;
                return handle.getHandle();
            }
            Type match = this.matches.fetch(type);
            if (match == null) {
                Type actual = this.loader.loadType(type);
                if (actual != null) {
                    this.matches.cache(type, actual);
                }
                return actual;
            }
            return match;
        }
        return null;
    }

    public Set<Type> getTypes(Object value) {
        Type type = this.getType(value);
        if (type != null) {
            return this.traverser.findHierarchy(type);
        }
        return null;
    }

    public Set<Type> getTypes(Type type) {
        return this.traverser.findHierarchy(type);
    }
}

