/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core;

import org.snapscript.core.ModuleRegistry;
import org.snapscript.core.ResourceManager;
import org.snapscript.core.Type;
import org.snapscript.core.extend.ClassExtender;
import org.snapscript.core.index.TypeIndexer;
import org.snapscript.core.link.ImportScanner;
import org.snapscript.core.link.Package;
import org.snapscript.core.link.PackageLinker;
import org.snapscript.core.link.PackageLoader;
import org.snapscript.core.link.PackageManager;

public class TypeLoader {
    private final PackageManager manager;
    private final PackageLoader loader;
    private final ImportScanner scanner = new ImportScanner();
    private final TypeIndexer indexer;
    private final ClassExtender extender = new ClassExtender(this);

    public TypeLoader(PackageLinker linker, ModuleRegistry registry, ResourceManager manager) {
        this.indexer = new TypeIndexer(registry, this.scanner, this.extender);
        this.loader = new PackageLoader(linker, manager);
        this.manager = new PackageManager(this.loader, this.scanner);
    }

    public Package importPackage(String module) {
        return this.manager.importPackage(module);
    }

    public Package importType(String type) {
        return this.manager.importType(type);
    }

    public Package importType(String module, String name) {
        return this.manager.importType(module, name);
    }

    public Type defineType(String module, String name) {
        return this.indexer.defineType(module, name);
    }

    public Type resolveType(String module, String name) {
        return this.indexer.loadType(module, name);
    }

    public Type resolveType(String module, String name, int size) {
        return this.indexer.loadType(module, name, size);
    }

    public Type resolveType(String type) {
        return this.indexer.loadType(type);
    }

    public Type loadType(Class type) {
        return this.indexer.loadType(type);
    }
}

