/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core;

import org.snapscript.core.InternalArgumentException;
import org.snapscript.core.NameBuilder;

public class TypeNameBuilder
implements NameBuilder {
    private static final String[] DIMENSIONS = new String[]{"", "[]", "[][]", "[][][]"};
    private static final String DIMENSION = "[]";

    @Override
    public String createFullName(Class type) {
        Class<?> entry = type.getComponentType();
        if (entry != null) {
            return this.createFullName(entry) + DIMENSION;
        }
        return type.getName();
    }

    @Override
    public String createShortName(Class type) {
        Class<?> entry = type.getComponentType();
        if (entry != null) {
            return this.createShortName(entry) + DIMENSION;
        }
        String name = type.getName();
        int index = name.lastIndexOf(46);
        int length = name.length();
        if (index > 0) {
            return name.substring(index + 1, length);
        }
        return name;
    }

    @Override
    public String createFullName(String module, String name) {
        if (module == null) {
            return name;
        }
        if (name == null) {
            return module;
        }
        return module + "." + name;
    }

    @Override
    public String createArrayName(String module, String name, int size) {
        int limit = DIMENSIONS.length;
        if (size >= DIMENSIONS.length) {
            throw new InternalArgumentException("Maximum of " + limit + " dimensions exceeded");
        }
        String bounds = DIMENSIONS[size];
        if (module != null) {
            return this.createFullName(module, name) + bounds;
        }
        return name + bounds;
    }

    @Override
    public String createOuterName(String module, String name) {
        String parent;
        int length;
        int index;
        if (name != null && (index = name.lastIndexOf(36)) > 0 && (length = (parent = name.substring(0, index)).length()) > 0) {
            return this.createFullName(module, parent);
        }
        return null;
    }

    @Override
    public String createTopName(String type) {
        if (type != null) {
            int index = type.indexOf(36);
            if (index > 0) {
                return type.substring(0, index);
            }
            return type;
        }
        return null;
    }

    @Override
    public String createTopName(String module, String name) {
        if (name != null) {
            String parent;
            int length;
            int index = name.indexOf(36);
            if (index > 0 && (length = (parent = name.substring(0, index)).length()) > 0) {
                return this.createFullName(module, parent);
            }
            return this.createFullName(module, name);
        }
        return null;
    }
}

