/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.snapscript.core.InternalStateException;
import org.snapscript.core.Module;
import org.snapscript.core.Type;
import org.snapscript.core.TypeCache;

public class TypeTraverser {
    private final TypeCache<Set<Type>> types = new TypeCache();

    public Set<Type> findHierarchy(Type type) {
        Set<Type> list = this.types.fetch(type);
        if (list == null) {
            list = this.findHierarchy(type, type);
            this.types.cache(type, list);
        }
        return list;
    }

    private Set<Type> findHierarchy(Type root, Type type) {
        LinkedHashSet<Type> list = new LinkedHashSet<Type>();
        if (type != null) {
            this.findHierarchy(root, type, list);
        }
        return Collections.unmodifiableSet(list);
    }

    private Set<Type> findHierarchy(Type root, Type type, Set<Type> list) {
        List<Type> types = type.getTypes();
        if (list.add(type)) {
            for (Type entry : types) {
                if (entry == root) {
                    throw new InternalStateException("Hierarchy for '" + type + "' contains a cycle");
                }
                this.findHierarchy(root, entry, list);
            }
        }
        return list;
    }

    public Type findEnclosing(Type type, String name) {
        LinkedHashSet<Type> done = new LinkedHashSet<Type>();
        if (type != null) {
            return this.findEnclosing(type, name, done);
        }
        return null;
    }

    private Type findEnclosing(Type type, String name, Set<Type> done) {
        Module module = type.getModule();
        while (type != null) {
            String prefix = type.getName();
            Type result = module.getType(prefix + "$" + name);
            if (result == null) {
                result = this.findHierarchy(type, name, done);
            }
            if (result != null) {
                return result;
            }
            type = type.getOuter();
        }
        return null;
    }

    private Type findHierarchy(Type type, String name, Set<Type> done) {
        List<Type> types = type.getTypes();
        for (Type base : types) {
            Type result;
            if (!done.add(base) || (result = this.findEnclosing(base, name, done)) == null) continue;
            return result;
        }
        return null;
    }
}

