/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core;

import org.snapscript.core.Type;
import org.snapscript.core.TypeCastChecker;
import org.snapscript.core.TypeLoader;
import org.snapscript.core.convert.Score;

public class TypeVerifier {
    private final TypeCastChecker checker;
    private final TypeLoader loader;

    public TypeVerifier(TypeLoader loader, TypeCastChecker checker) {
        this.checker = checker;
        this.loader = loader;
    }

    public boolean isSame(Type type, Class require) throws Exception {
        Class actual = type.getType();
        return actual == require;
    }

    public boolean isLike(Type type, Class require) throws Exception {
        Type actual = this.loader.loadType(require);
        Score score = this.checker.cast(type, actual);
        return score.compareTo(Score.INVALID) > 0;
    }

    public boolean isArray(Type type) throws Exception {
        Type entry = type.getEntry();
        return entry != null;
    }
}

