/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.snapscript.core.InternalArgumentException;
import org.snapscript.core.annotation.MapAnnotation;

public class AnnotationConverter {
    public Object convert(Object object) throws Exception {
        if (object != null) {
            Class type = this.extractType(object);
            if (type.isArray()) {
                return this.convertArray(object);
            }
            if (type.isAnnotation()) {
                return this.convertValue(object);
            }
            return object;
        }
        return null;
    }

    private Object convertArray(Object object) throws Exception {
        int length = Array.getLength(object);
        if (length < 0) {
            throw new InternalArgumentException("Invalid array length " + length);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < length; ++i) {
            Object value = Array.get(object, i);
            if (value != null) {
                value = this.convert(value);
            }
            list.add(value);
        }
        return list;
    }

    private Object convertValue(Object object) throws Exception {
        Class type = this.extractType(object);
        String name = type.getSimpleName();
        Method[] methods = type.getDeclaredMethods();
        if (!type.isAnnotation()) {
            throw new InternalArgumentException("Invalid annotation " + type);
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        MapAnnotation annotation = new MapAnnotation(name, map);
        for (Method method : methods) {
            String key = method.getName();
            Object value = method.invoke(object, new Object[0]);
            Object conversion = this.convert(value);
            map.put(key, conversion);
        }
        return annotation;
    }

    private Class extractType(Object value) throws Exception {
        Class<?> type = value.getClass();
        if (Annotation.class.isInstance(value)) {
            Annotation annotation = (Annotation)value;
            return annotation.annotationType();
        }
        return type;
    }
}

