/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.bind;

import java.util.List;
import org.snapscript.core.Type;
import org.snapscript.core.TypeExtractor;
import org.snapscript.core.bind.FunctionCache;
import org.snapscript.core.bind.FunctionCacheIndexer;
import org.snapscript.core.bind.FunctionCacheTable;
import org.snapscript.core.bind.FunctionKeyBuilder;
import org.snapscript.core.bind.FunctionPathFinder;
import org.snapscript.core.bind.FunctionPointer;
import org.snapscript.core.bind.TypeCacheIndexer;
import org.snapscript.core.convert.Delegate;
import org.snapscript.core.convert.ProxyTypeFilter;
import org.snapscript.core.convert.Score;
import org.snapscript.core.function.ArgumentConverter;
import org.snapscript.core.function.EmptyFunction;
import org.snapscript.core.function.Function;
import org.snapscript.core.function.Signature;
import org.snapscript.core.stack.ThreadStack;

public class DelegateFunctionMatcher {
    private final FunctionCacheIndexer<Type> indexer = new TypeCacheIndexer();
    private final FunctionCacheTable<Type> table = new FunctionCacheTable<Type>(this.indexer);
    private final FunctionKeyBuilder builder;
    private final FunctionPathFinder finder;
    private final ProxyTypeFilter filter;
    private final TypeExtractor extractor;
    private final ThreadStack stack;
    private final Function invalid;

    public DelegateFunctionMatcher(TypeExtractor extractor, ThreadStack stack) {
        this.builder = new FunctionKeyBuilder(extractor);
        this.finder = new FunctionPathFinder();
        this.invalid = new EmptyFunction(null);
        this.filter = new ProxyTypeFilter();
        this.extractor = extractor;
        this.stack = stack;
    }

    public FunctionPointer match(Delegate value, String name, Object ... values) throws Exception {
        Type type = this.extractor.getType(value);
        Function function = this.resolve(type, name, values);
        if (function != this.invalid) {
            return new FunctionPointer(function, this.stack, values);
        }
        return null;
    }

    public Function resolve(Type type, String name, Object ... values) throws Exception {
        Object key = this.builder.create(name, values);
        FunctionCache cache = this.table.get(type);
        Function function = cache.fetch(key);
        if (function == null) {
            List<Type> path = this.finder.findPath(type, name);
            Score best = Score.INVALID;
            for (Type entry : path) {
                if (!this.filter.accept(entry)) continue;
                List<Function> functions = entry.getFunctions();
                int size = functions.size();
                for (int i = size - 1; i >= 0; --i) {
                    Signature signature;
                    ArgumentConverter match;
                    Score score;
                    Function next = functions.get(i);
                    String method = next.getName();
                    if (!name.equals(method) || (score = (match = (signature = next.getSignature()).getConverter()).score(values)).compareTo(best) <= 0) continue;
                    function = next;
                    best = score;
                }
            }
            if (best.isFinal()) {
                if (function == null) {
                    function = this.invalid;
                }
                cache.cache(key, function);
            }
        }
        return function;
    }
}

