/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.bind;

import org.snapscript.core.bind.FunctionCache;
import org.snapscript.core.bind.FunctionCacheArray;
import org.snapscript.core.bind.FunctionCacheIndexer;

public class FunctionCacheTable<T> {
    private volatile FunctionCacheIndexer<T> indexer;
    private volatile FunctionCacheArray array;
    private volatile CacheAllocator allocator;

    public FunctionCacheTable(FunctionCacheIndexer<T> indexer) {
        this(indexer, 5000);
    }

    public FunctionCacheTable(FunctionCacheIndexer<T> indexer, int capacity) {
        this.array = new FunctionCacheArray(capacity, capacity);
        this.allocator = new CacheAllocator(indexer);
        this.indexer = indexer;
    }

    public FunctionCache get(T value) {
        int length;
        int index = this.indexer.index(value);
        if (index >= (length = this.array.length())) {
            return this.allocator.allocate(value);
        }
        FunctionCache cache = this.array.get(index);
        if (cache == null) {
            return this.allocator.allocate(value);
        }
        return cache;
    }

    private class CacheAllocator {
        private final FunctionCacheIndexer<T> indexer;

        public CacheAllocator(FunctionCacheIndexer<T> indexer) {
            this.indexer = indexer;
        }

        public synchronized FunctionCache allocate(T value) {
            int index = this.indexer.index(value);
            FunctionCacheArray local = FunctionCacheTable.this.array.copy(index);
            FunctionCache cache = local.get(index);
            if (cache == null) {
                cache = new FunctionCache();
                local.set(index, cache);
                FunctionCacheTable.this.array = local;
            }
            return cache;
        }
    }
}

