/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.bind;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.snapscript.core.Type;
import org.snapscript.core.TypeCache;
import org.snapscript.core.convert.ProxyTypeFilter;

public class FunctionPathFinder {
    private final TypeCache<List<Type>> paths = new TypeCache();
    private final ProxyTypeFilter filter = new ProxyTypeFilter();

    public List<Type> findPath(Type type, String name) {
        if (name.equals("new")) {
            return Arrays.asList(type);
        }
        return this.findTypes(type, name);
    }

    private List<Type> findTypes(Type type, String name) {
        List<Type> path = this.paths.fetch(type);
        Class real = type.getType();
        if (path == null) {
            ArrayList<Type> result = new ArrayList<Type>();
            this.findClasses(type, result);
            if (real == null) {
                this.findTraits(type, result);
            }
            this.paths.cache(type, result);
            return result;
        }
        return path;
    }

    private void findTraits(Type type, List<Type> done) {
        List<Type> types = type.getTypes();
        Iterator<Type> iterator = types.iterator();
        if (iterator.hasNext()) {
            Type next = iterator.next();
            for (Type entry : types) {
                if (done.contains(entry)) continue;
                done.add(entry);
            }
            this.findTraits(next, done);
        }
    }

    private void findClasses(Type type, List<Type> done) {
        List<Type> types = type.getTypes();
        Iterator<Type> iterator = types.iterator();
        if (this.filter.accept(type)) {
            done.add(type);
        }
        while (iterator.hasNext()) {
            Type next = iterator.next();
            if (done.contains(next)) continue;
            this.findClasses(next, done);
        }
    }
}

