/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.bind;

import java.util.List;
import org.snapscript.core.Module;
import org.snapscript.core.TypeExtractor;
import org.snapscript.core.bind.FunctionCache;
import org.snapscript.core.bind.FunctionCacheIndexer;
import org.snapscript.core.bind.FunctionCacheTable;
import org.snapscript.core.bind.FunctionKeyBuilder;
import org.snapscript.core.bind.FunctionPointer;
import org.snapscript.core.bind.ModuleCacheIndexer;
import org.snapscript.core.convert.Score;
import org.snapscript.core.function.ArgumentConverter;
import org.snapscript.core.function.EmptyFunction;
import org.snapscript.core.function.Function;
import org.snapscript.core.function.Signature;
import org.snapscript.core.stack.ThreadStack;

public class ModuleFunctionMatcher {
    private final FunctionCacheIndexer<Module> indexer = new ModuleCacheIndexer();
    private final FunctionCacheTable<Module> table = new FunctionCacheTable<Module>(this.indexer);
    private final FunctionKeyBuilder builder;
    private final ThreadStack stack;
    private final Function invalid;

    public ModuleFunctionMatcher(TypeExtractor extractor, ThreadStack stack) {
        this.builder = new FunctionKeyBuilder(extractor);
        this.invalid = new EmptyFunction(null);
        this.stack = stack;
    }

    public FunctionPointer match(Module module, String name, Object ... values) throws Exception {
        Object key = this.builder.create(name, values);
        FunctionCache cache = this.table.get(module);
        Function function = cache.fetch(key);
        if (function == null) {
            List<Function> functions = module.getFunctions();
            int size = functions.size();
            Score best = Score.INVALID;
            for (int i = size - 1; i >= 0; --i) {
                Signature signature;
                ArgumentConverter match;
                Score score;
                Function next = functions.get(i);
                String method = next.getName();
                if (!name.equals(method) || (score = (match = (signature = next.getSignature()).getConverter()).score(values)).compareTo(best) <= 0) continue;
                function = next;
                best = score;
            }
            if (best.isFinal()) {
                if (function == null) {
                    function = this.invalid;
                }
                cache.cache(key, function);
            }
        }
        if (function != this.invalid) {
            return new FunctionPointer(function, this.stack, values);
        }
        return null;
    }
}

