/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.bridge;

public enum Platform {
    ANDROID("android.os.Build"),
    STANDARD("java.awt.Frame");

    private final String type;

    private Platform(String type) {
        this.type = type;
    }

    public static Platform resolvePlatform() {
        Platform[] types;
        for (Platform type : types = Platform.values()) {
            try {
                Class.forName(type.type);
            }
            catch (Exception e) {
                continue;
            }
            return type;
        }
        return STANDARD;
    }
}

