/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.bridge;

import java.lang.reflect.Constructor;
import java.util.concurrent.atomic.AtomicReference;
import org.snapscript.core.Any;
import org.snapscript.core.ContextClassLoader;
import org.snapscript.core.Type;
import org.snapscript.core.bind.FunctionResolver;
import org.snapscript.core.bridge.Platform;
import org.snapscript.core.bridge.PlatformNameBuilder;

public class PlatformClassLoader {
    private final AtomicReference<Constructor> reference;
    private final PlatformNameBuilder builder;
    private final ClassLoader loader;
    private final Class[] types = new Class[]{FunctionResolver.class, Type.class};

    public PlatformClassLoader() {
        this.reference = new AtomicReference();
        this.loader = new ContextClassLoader(Any.class);
        this.builder = new PlatformNameBuilder();
    }

    public Constructor loadConstructor() {
        Constructor<?> constructor = this.reference.get();
        if (constructor == null) {
            try {
                Platform platform = Platform.resolvePlatform();
                String type = this.builder.createFullName(platform);
                Class<?> value = this.loader.loadClass(type);
                constructor = value.getDeclaredConstructor(this.types);
                this.reference.set(constructor);
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not load constructor", e);
            }
        }
        return constructor;
    }
}

