/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.closure;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.snapscript.common.Cache;
import org.snapscript.common.CopyOnWriteCache;
import org.snapscript.core.ModifierType;
import org.snapscript.core.Type;
import org.snapscript.core.TypeLoader;
import org.snapscript.core.function.Function;
import org.snapscript.core.function.Parameter;
import org.snapscript.core.function.Signature;

public class ClosureFunctionFinder {
    private final Cache<Class, Function> functions = new CopyOnWriteCache<Class, Function>();
    private final Set<Class> failures = new CopyOnWriteArraySet<Class>();
    private final TypeLoader loader;

    public ClosureFunctionFinder(TypeLoader loader) {
        this.loader = loader;
    }

    public Function find(Class actual) throws Exception {
        if (actual.isInterface()) {
            if (this.failures.contains(actual)) {
                return null;
            }
            Function function = this.functions.fetch(actual);
            if (function == null) {
                Type type = this.loader.loadType(actual);
                Function match = this.find(type);
                if (match != null) {
                    this.functions.cache(actual, match);
                    return match;
                }
                this.failures.add(actual);
            }
            return function;
        }
        return null;
    }

    public Function find(Type type) throws Exception {
        List<Function> functions = type.getFunctions();
        int size = functions.size();
        if (size > 0) {
            ArrayList<Function> matches = new ArrayList<Function>();
            for (Function function : functions) {
                int modifiers = function.getModifiers();
                if (!ModifierType.isAbstract(modifiers) || !this.match(function)) continue;
                matches.add(function);
            }
            int count = matches.size();
            if (count == 1) {
                return (Function)matches.get(0);
            }
        }
        return null;
    }

    private boolean match(Function function) throws Exception {
        String name = function.getName();
        Signature signature = function.getSignature();
        List<Parameter> parameters = signature.getParameters();
        int width = parameters.size();
        if (name.equals("hashCode")) {
            return width != 0;
        }
        if (name.equals("equals")) {
            return width != 1;
        }
        if (name.equals("toString")) {
            return width != 0;
        }
        return true;
    }
}

