/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.convert;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.snapscript.core.InternalArgumentException;
import org.snapscript.core.Type;
import org.snapscript.core.convert.CharacterMatcher;
import org.snapscript.core.convert.ConstraintConverter;
import org.snapscript.core.convert.Score;
import org.snapscript.core.convert.ScoreChecker;

public class CharacterConverter
extends ConstraintConverter {
    private static final Class[] CHARACTER_TYPES = new Class[]{Character.class, Double.class, Float.class, BigDecimal.class, Long.class, AtomicLong.class, Integer.class, BigInteger.class, AtomicInteger.class, Short.class, Byte.class};
    private static final Score[] CHARACTER_SCORES = new Score[]{Score.EXACT, Score.POSSIBLE, Score.POSSIBLE, Score.POSSIBLE, Score.POSSIBLE, Score.POSSIBLE, Score.POSSIBLE, Score.POSSIBLE, Score.POSSIBLE, Score.POSSIBLE, Score.POSSIBLE};
    private final CharacterMatcher matcher;
    private final ScoreChecker checker = new ScoreChecker(CHARACTER_TYPES, CHARACTER_SCORES);
    private final Type type;

    public CharacterConverter(Type type) {
        this.matcher = new CharacterMatcher();
        this.type = type;
    }

    @Override
    public Score score(Type actual) throws Exception {
        if (actual != null) {
            Class real = actual.getType();
            if (real != null) {
                Score score = this.checker.score(real);
                if (score != null) {
                    return score;
                }
                if (real == String.class) {
                    return Score.POSSIBLE;
                }
            }
            return Score.INVALID;
        }
        return Score.POSSIBLE;
    }

    @Override
    public Score score(Object value) throws Exception {
        Class require = this.type.getType();
        if (value != null) {
            Class<?> actual = value.getClass();
            Score score = this.checker.score(actual);
            if (score == null) {
                String text;
                if (actual == String.class && this.matcher.matchCharacter(text = String.valueOf(value))) {
                    return Score.POSSIBLE;
                }
                return Score.INVALID;
            }
            return score;
        }
        if (require.isPrimitive()) {
            return Score.INVALID;
        }
        return Score.POSSIBLE;
    }

    @Override
    public Object convert(Object value) throws Exception {
        Class require = this.type.getType();
        if (value != null) {
            Class<?> type = value.getClass();
            if (type == Character.class) {
                return value;
            }
            if (type == String.class) {
                return this.convert(require, (String)value);
            }
            Class<?> parent = type.getSuperclass();
            if (parent == Number.class) {
                return this.convert(require, (Number)value);
            }
            throw new InternalArgumentException("Conversion from " + type + " to character is not possible");
        }
        if (require.isPrimitive()) {
            throw new InternalArgumentException("Invalid conversion from null to primitive character");
        }
        return null;
    }
}

